<?php
namespace Kueski\Payment\Helper;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Sales\Model\OrderRepository;

class Order
{
    /**
     * @var OrderRepository
     */
    protected $_orderRepository;
    /**
     * @var SearchCriteriaBuilder
     */
    protected $_searchCriteriaBuilder;

    /**
     * @param OrderRepository $orderRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        OrderRepository $orderRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        $this->_orderRepository = $orderRepository;
        $this->_searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @param $orderId
     * @param $field
     * @return false|mixed
     */
    public function getOrder($orderId, $field = 'increment_id')
    {
        $search = $this->_searchCriteriaBuilder->addFilter($field, $orderId)
            ->create();

        $order = $this->_orderRepository->getList($search)
            ->getItems();

        $order = current($order);

        if (!$order->getId()) {
            return false;
        }

        $this->_order = $order;
        return $order;
    }

}
