<?php

namespace Kueski\Payment\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use \Magento\Framework\App\Helper\AbstractHelper;

class Widget extends AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;
    /**
     * @var \Kueski\Payment\Logger\Logger
     */
    protected  $_kueskiLog;

    /**
     * @param Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Kueski\Payment\Logger\Logger $kueskiLog
     */
    public function __construct(
        Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Kueski\Payment\Logger\Logger $kueskiLog
    )
    {
        parent::__construct($context);
        $this->_scopeConfig = $scopeConfig;
        $this->_kueskiLog = $kueskiLog;
    }

    public function isActive()
    {
        return $this->_scopeConfig->getValue("payment/kueski/widget_general/active",
            ScopeInterface::SCOPE_STORE);
    }

    public function isActivePDP()
    {
        return $this->_scopeConfig->getValue("payment/kueski/widget_general/active_pdp",
            ScopeInterface::SCOPE_STORE);
    }

    public function isActiveCart()
    {
        return $this->_scopeConfig->getValue("payment/kueski/widget_general/active_cart",
            ScopeInterface::SCOPE_STORE);
    }


    public function isSandbox()
    {
        return $this->_scopeConfig->getValue("payment/kueski/widget_general/is_sandbox",
            ScopeInterface::SCOPE_STORE);
    }

    public function getApiKey()
    {
        return $this->_scopeConfig->getValue("payment/kueski/api_key", ScopeInterface::SCOPE_STORE);
    }

    public function getFontSize()
    {
        return $this->_scopeConfig->getValue("payment/kueski/attributes/font_size",
            ScopeInterface::SCOPE_STORE);
    }

    public function getTextAlign()
    {
        return $this->_scopeConfig->getValue("payment/kueski/attributes/text_align",
            ScopeInterface::SCOPE_STORE);
    }


    public function getLinkColor()
    {
        return $this->_scopeConfig->getValue("payment/kueski/attributes/link_color",
            ScopeInterface::SCOPE_STORE);
    }


}
