<?php
namespace Kueski\Payment\Model\Checkout;

use Kueski\Payment\Model\KueskiConfigProvider as ConfigProvider;

class GuestTotalsInformationManagement extends \Magento\Checkout\Model\GuestTotalsInformationManagement
{
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;

    /**
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory
     * @param \Magento\Checkout\Api\TotalsInformationManagementInterface $totalsInformationManagement
     */
    public function __construct(
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory,
        \Magento\Checkout\Api\TotalsInformationManagementInterface $totalsInformationManagement
    ) {
        parent::__construct($quoteIdMaskFactory, $totalsInformationManagement);
        $this->_checkoutSession = $checkoutSession;
    }

    /**
     * @param $cartId
     * @param \Magento\Checkout\Api\Data\TotalsInformationInterface $addressInformation
     * @return \Magento\Quote\Api\Data\TotalsInterface
     */
    public function calculate($cartId, $addressInformation)
    {
        $totals = parent::calculate($cartId, $addressInformation);
        $this->setExtraGrandTotal($totals);
        return $totals;
    }

    /**
     * @param \Magento\Quote\Api\Data\TotalsInterface $totals
     */
    private function setExtraGrandTotal($totals)
    {
        $this->_checkoutSession->setData(ConfigProvider::CHECKOUT_TOTALS_INFORMATION, $totals->getGrandTotal());
    }
}
