<?php
namespace Kueski\Payment\Model\Payment;

use Kueski\Kueski as KueskiLib;
use Kueski\Payment\Exceptions\KueskiException;

class Integration
{
    private $kueskiEndpoint    = '';

    /**
     * @param string $key
     * @param bool $isSandbox
     * @return bool|array
     * @throws KueskiExceptions
     */
    public function validateCredentials($key, $isSandbox = false)
    {
        $url = $isSandbox ? KueskiLib::URL_SANDBOX : KueskiLib::URL_PRODUCTION;
        $url = $url . "v1/validate-keys?api_key=" . $key;

        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 0);
            $result = json_decode(curl_exec($ch), true);
            curl_close($ch);
        } catch (\Exception $e) {
               throw new KueskiException(__($e->getMessage()));
        }

        if (!isset($result['status']) || $result['status'] !== 'success') {
            return false;
        }

        return $result;
    }
}
