<?php
namespace Kueski\Payment\Model\Payment\Validator;

use Kueski\Payment\Exceptions\KueskiException;
use Kueski\Payment\Helper\Order as OrderHelper;
use Magento\Framework\Controller\Result\JsonFactory;

class Controller
{
    /**
     * @var OrderHelper
     */
    protected $_orderHelper;
    /**
     * @var JsonFactory
     */
    private $jsonFactory;

    /**
     * @param OrderHelper $orderHelper
     * @param JsonFactory $jsonFactory
     */
    public function __construct(
        OrderHelper $orderHelper,
        JsonFactory $jsonFactory
    ) {
        $this->_orderHelper = $orderHelper;
        $this->jsonFactory = $jsonFactory;
    }

    /**
     * @param \Magento\Framework\App\Action\Action $subject
     * @param callable $proceed
     * @return \Magento\Framework\Controller\Result\Json | callable
     */
    public function aroundExecute(
        \Magento\Framework\App\Action\Action $subject,
        callable $proceed
    ) {
        $params = file_get_contents("php://input");
        $params = json_decode($params, true);

        try {
            if (!$this->validate($params['order_id'], $params['payment_id']))
            {
                throw new KueskiException(__('Invalid payment ID'));
            }
        } catch (KueskiException $e) {
            $result = $this->jsonFactory->create()
                ->setData([
                    'result' => 'error',
                    'response' => $e->getMessage()
                ]);

            return $result;
        }

        return $proceed();
    }

    /**
     * @param string $orderIncrementId
     * @param string $paymentId
     * @return bool
     * @throws KueskiException
     */
    private function validate($orderIncrementId, $paymentId)
    {
        /* @var \Magento\Sales\Model\Order $order */
        $order = $this->_orderHelper->getOrder($orderIncrementId);
        if (!$order) {
            throw new KueskiException(__('Not possible to validate order'));
        }

        $orderPaymentId = $this->getOrderPaymentId($order);

        if ($orderPaymentId !== $paymentId) {
            return false;
        }

        return true;
    }

    /**
     * @param \Magento\Sales\Model\Order $order
     * @return void
     */
    private function getOrderPaymentId($order)
    {
        $paymentId = $order->getPayment()->getAdditionalInformation('Kueski ID');
        return $paymentId;
    }
}
