<?php

namespace Kueski\Payment\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;
use Psr\Log\LoggerInterface;

class PlaceOrderEmailSender implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var OrderSender
     */
    private $orderSender;

    /**
     * @param OrderSender $orderSender
     * @param LoggerInterface $logger
     */
    public function __construct(
        OrderSender $orderSender,
        LoggerInterface $logger
    ) {
        $this->orderSender = $orderSender;
        $this->logger = $logger;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        /** @var  Order $order */
        $order = $observer->getEvent()->getOrder();

        try {
            $this->orderSender->send($order);
        } catch (\Throwable $e) {
            $this->logger->critical($e);
        }
    }
}
