<?php


namespace Kueski\Payment\Setup;

use Magento\Quote\Setup\QuoteSetupFactory;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Sales\Setup\SalesSetupFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class InstallData implements InstallDataInterface
{

    protected $_quoteSetupFactory;
    protected $_salesSetupFactory;

    /**
     * Constructor
     *
     * @param \Magento\Quote\Setup\QuoteSetupFactory $quoteSetupFactory
     */
    public function __construct(
        QuoteSetupFactory $quoteSetupFactory,
        SalesSetupFactory $salesSetupFactory
    ) {
        $this->_quoteSetupFactory = $quoteSetupFactory;
        $this->_salesSetupFactory = $salesSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function install(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $quoteSetup = $this->_quoteSetupFactory->create(array('setup' => $setup));
        $quoteSetup->addAttribute(
            'quote', 'kueski_url',
            array(
                'type' => 'varchar',
                'length' => 512,
                'visible' => false,
                'required' => false,
                'grid' => false
            )
        );

        $salesSetup = $this->_salesSetupFactory->create(array('setup' => $setup));
        $salesSetup->addAttribute(
            'order', 'kueski_url',
            array(
                'type' => 'varchar',
                'length' => 512,
                'visible' => false,
                'required' => false,
                'grid' => false
            )
        );

        $quoteSetup = $this->_quoteSetupFactory->create(array('setup' => $setup));
        $quoteSetup->addAttribute(
            'quote', 'kueski_id',
            array(
                'type' => 'varchar',
                'length' => 512,
                'visible' => false,
                'required' => false,
                'grid' => false
            )
        );

        $salesSetup = $this->_salesSetupFactory->create(array('setup' => $setup));
        $salesSetup->addAttribute(
            'order', 'kueski_id',
            array(
                'type' => 'varchar',
                'length' => 512,
                'visible' => false,
                'required' => false,
                'grid' => false
            )
        );
    }
}
