<?php
namespace Kueski\Payment\Setup;

use Kueski\Payment\Model\Config as ConfigModel;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Sales\Model\Order\Status;
use Magento\Sales\Model\Order\StatusFactory;
use Magento\Sales\Model\ResourceModel\Order\Status as StatusResource;
use Magento\Sales\Model\ResourceModel\Order\StatusFactory as StatusResourceFactory;

class UpgradeData implements \Magento\Framework\Setup\UpgradeDataInterface
{
    /**
     * @var StatusFactory
     */
    private $statusFactory;
    /**
     * @var StatusResourceFactory
     */
    private $statusResourceFactory;

    /**
     * @param StatusFactory $statusFactory
     * @param StatusResourceFactory $statusResourceFactory
     */
    public function __construct(
        StatusFactory $statusFactory,
        StatusResourceFactory $statusResourceFactory
    ) {
        $this->statusFactory = $statusFactory;
        $this->statusResourceFactory = $statusResourceFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     */
    public function upgrade(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        if (version_compare($context->getVersion(), '2.4.0', '<')) {
            /** @var StatusResource $statusResource */
            $statusResource = $this->statusResourceFactory->create();

            $pendingStatus = $this->getOrderStatus(ConfigModel::ORDER_STATUS_PENDING_CODE);

            ////////////////////////////// PENDING
            if ($pendingStatus->getStatus() !== null) {
                $statusResource->unassignState($pendingStatus->getStatus(), 'payment_review');
                $statusResource->delete($pendingStatus);
            }

            /** @var Status $pendingStatus */
            $pendingStatus = $this->statusFactory->create();
            $pendingStatus->setData([
                'status' => ConfigModel::ORDER_STATUS_PENDING_CODE,
                'label' => ConfigModel::ORDER_STATUS_PENDING_LABEL,
            ]);

            $statusResource->save($pendingStatus);
            $pendingStatus->assignState('payment_review', false,false);

            ////////////////////////////// APPROVED
            $approvedStatus = $this->getOrderStatus(ConfigModel::ORDER_STATUS_APPROVED_CODE);
            if ($approvedStatus->getStatus() !== null) {
                $statusResource->unassignState($approvedStatus->getStatus(), 'processing');
                $statusResource->delete($approvedStatus);
            }

            $approvedStatus = $this->statusFactory->create();
            $approvedStatus->setData([
                'status' => ConfigModel::ORDER_STATUS_APPROVED_CODE,
                'label' => ConfigModel::ORDER_STATUS_APPROVED_LABEL,
            ]);

            $statusResource->save($approvedStatus);
            $approvedStatus->assignState('processing', false, false);

            ////////////////////////////// FAILED
            $failedStatus = $this->getOrderStatus(ConfigModel::ORDER_STATUS_FAILED_CODE);
            if ($failedStatus->getStatus() !== null) {
                $statusResource->unassignState($failedStatus->getStatus(), 'processing');
                $statusResource->delete($failedStatus);
            }

            $failedStatus = $this->statusFactory->create();
            $failedStatus->setData([
                'status' => ConfigModel::ORDER_STATUS_FAILED_CODE,
                'label' => ConfigModel::ORDER_STATUS_FAILED_LABEL,
            ]);

            $statusResource->save($failedStatus);
            $failedStatus->assignState('canceled', false, false);
        }
    }

    /**
     * @param $statusCode
     * @return \Magento\Sales\Model\Order\Status
     */
    private function getOrderStatus($statusCode)
    {
        /* @var \Magento\Sales\Model\Order\Status $model */
        $status = $this->statusFactory->create();
        $status->getResource()->load($status, $statusCode, 'status');

        return $status;
    }
}
