<?php
namespace Kueski\Payment\ViewModel\Widget;

use Kueski\Payment\Model\KueskiConfigProvider as ConfigProvider;
use Magento\Framework\Exception\LocalizedException;
use Magento\Quote\Model\Quote;

class CheckoutAmount implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;
    /**
     * @var \Magento\Quote\Model\Quote\Address\Total
     */
    protected $_addressTotal;

    /**
     * CheckoutAmount constructor.
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param Quote\Address\Total $addressTotal
     */
    public function __construct(
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Quote\Model\Quote\Address\Total $addressTotal
    ) {
        $this->_checkoutSession = $checkoutSession;
        $this->_addressTotal = $addressTotal;
    }

    /**
     * @return float
     */
    public function getAmount()
    {
        $amount = $this->getApiGrandTotal();

        if ($amount === null) {
            try {
                $amount = $this->getCheckoutQuote()->getGrandTotal();
            } catch (LocalizedException $e) {
                //Possibly failure to get into `Quote` object data
                $amount = 0;
            }
        }

        return self::priceMultiplierFactor((float)$amount);
    }

    /**
     * @param float $amount
     * @param int $multiplier
     * @return float
     */
    protected static function priceMultiplierFactor($amount, $multiplier = 100)
    {
        return $amount * $multiplier;
    }

    /**
     * @return float | null
     */
    protected function getApiGrandTotal()
    {
        $grandTotal = $this->_checkoutSession->getData(ConfigProvider::CHECKOUT_TOTALS_INFORMATION);

        if ($grandTotal) {
            $this->_checkoutSession->unset(ConfigProvider::CHECKOUT_TOTALS_INFORMATION);
            return $grandTotal;
        }

        return null;
    }

    /**
     * @return Quote
     * @throws LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    private function getCheckoutQuote()
    {
        $quote = $this->_checkoutSession->getQuote();
        $quote->collectTotals();
        return $quote;
    }
}
