<?php
namespace Kueski\Payment\ViewModel\Widget;

class ProductAmount implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    const PRODUCT_REGISTRY_KEY = 'product';

    public function __construct(
        \Magento\Framework\Registry $coreRegistry
    ) {
        $this->_coreRegistry = $coreRegistry;
    }

    /**
     * @return float|null
     */
    public function getAmount()
    {
        $price = null;
        $product = $this->getCurrentProduct();

        if ($product->getId()) {
            $price = $product->getPrice();
        }

        return self::priceMultiplierFactor((float)$price);
    }

    /**
     * @return \Magento\Catalog\Api\Data\ProductInterface|null
     */
    private function getCurrentProduct()
    {
        return $this->_coreRegistry->registry(self::PRODUCT_REGISTRY_KEY);
    }

    /**
     * @param float $amount
     * @param int $multiplier
     * @return float
     */
    protected static function priceMultiplierFactor($amount, $multiplier = 100)
    {
        return $amount * $multiplier;
    }
}
