define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/model/full-screen-loader',
        'mage/url'
    ],
    function (
        $,
        Component,
        fullScreenLoader,
        url
    ) {
        'use strict';
        return Component.extend({
            redirectAfterPlaceOrder: false,
            defaults: {
                template: 'Kueski_Payment/payment/kueski'
            },
            afterPlaceOrder: function () {
                $.ajax({
                    type: "POST",
                    async: false,
                    url: url.build('kueski/gateway/redirector'),
                    dataType:"json",
                    success: function(data){
                        window.checkoutConfig.defaultSuccessPageUrl = data.gateway;
                        window.location = data.gateway;
                        fullScreenLoader.stopLoader();
                    }
                });
            },

            getImage: function () {
                return window.checkoutConfig.payment.kueski_payment.image;
            }
        });
    }
);
