<?php
/**
 * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license
 */
namespace Temando\Shipping\Rest\SchemaMapper\Reflection;

/**
 * Temando Property Handler
 *
 * @package  Temando\Shipping\Rest
 * @author   Christoph Aßmann <christoph.assmann@netresearch.de>
 * @license  http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link     http://www.temando.com/
 */
class PropertyHandler implements PropertyHandlerInterface
{
    /**
     * Convert snake case to UpperCamelCase.
     *
     * @param string $key
     * @return string
     */
    public function camelizeUp($key)
    {
        // separate
        $key = str_replace('_', ' ', $key);
        // camelize separated words
        $key = ucwords($key);
        // remove whitespace
        $key = str_replace(' ', '', $key);

        return $key;
    }

    /**
     * Convert snake case to lowerCamelCase.
     *
     * @param string $key
     * @return string
     */
    public function camelizeLow($key)
    {
        // camelize
        $key = $this->camelizeUp($key);
        // convert first character to lower case
        $key = lcfirst($key);

        return $key;
    }

    /**
     * Convert Capitalized, UpperCamelCase or lowerCamelCase to snake case.
     *
     * @param string $key
     * @return string
     */
    public function underscore($key)
    {
        // separate
        $key = preg_replace('/(.)([A-Z])/', "$1_$2", $key);
        // convert to lower case
        $key = strtolower($key);

        return $key;
    }

    /**
     * Obtain getter method name from snake case property name.
     *
     * @param string $key
     * @return string
     */
    public function getter($key)
    {
        $key = $this->camelizeUp($key);
        return "get$key";
    }

    /**
     * Obtain setter method name from snake case property name.
     *
     * @param string $key
     * @return string
     */
    public function setter($key)
    {
        $key = $this->camelizeUp($key);
        return "set$key";
    }
}
