<?php
/**
 * @copyright: Copyright © 2021 Firebear Studio. All rights reserved.
 * @author: Firebear Studio <fbeardev@gmail.com>
 */
namespace Firebear\ImportExport\Model\Job\Handler;

use Firebear\ImportExport\Api\Data\ImportInterface;
use Firebear\ImportExport\Model\Job\Processor;

/**
 * @api
 */
class FileHandler implements HandlerInterface
{
    /**
     * @var Processor
     */
    private $processor;

    /**
     * @param Processor $importProcessor
     */
    public function __construct(
        Processor $processor
    ) {
        $this->processor = $processor;
    }

    /**
     * Execute the handler
     *
     * @param ImportInterface $job
     * @param string $file
     * @param int $status
     * @return void
     */
    public function execute(ImportInterface $job, $file, $status)
    {
        $data = $job->getSourceData();
        if (!empty($data['delete_file_after_import'])) {
            $import = $this->processor->getImportModel();
            $platform = $import->getPlatform($data['platforms'] ?? null, $job->getEntity());

            $isGateway = $platform && $platform->isGateway();
            if (!$isGateway && $import->getSource()->isAllowedDelete()) {
                if ($import->getSource()->deleteFile()) {
                    $this->processor->addLogComment(
                        __('The Import File Deleted Successfully'),
                        $this->processor->getOutput(),
                        'info'
                    );
                } else {
                    $this->processor->addLogComment(
                        __('There was an error in removal of file or Already Removed'),
                        $this->processor->getOutput(),
                        'error'
                    );
                }
            }
        }
    }
}
